from OpenGL.GL import *
from OpenGL.GLU import *
from pygame.locals import *
from math import *
import array
import pygame
import time
import sys
from random import random
import shader

X = 800
Y = 600

def init():    
    global texID

    pygame.init()    
    pygame.display.set_mode((X, Y), DOUBLEBUF | OPENGL)

    shader.create(X, Y)

    # make a texture for the framebuffer
    glEnable(GL_TEXTURE_2D)
    texID = glGenTextures(1)
    data = '\0' * X * Y * 4
    glBindTexture(GL_TEXTURE_2D, texID)
    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, X, Y, 0, GL_RGBA, GL_UNSIGNED_BYTE, data)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
    #glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_R, GL_CLAMP)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
                    

theta = 0
toggle = True

def draw():
    global theta
    theta += 1

    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluPerspective(40, float(X)/Y, 0.1, 100)
    gluLookAt(0, 0, 5,
	      0, 0, 0,
	      0, 1, 0)

    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()


    # draw a cube
    glDisable(GL_TEXTURE_2D)

    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    
    glLoadIdentity();
    glRotatef(theta, 0, 1, 1);
    
    glBegin(GL_QUADS);
    glColor3f(0.4, 0.4, 1);
    glNormal3f( 0,  0,  1);
    glVertex3f(-1, -1,  1);
    glVertex3f( 1, -1,  1);
    glVertex3f( 1,  1,  1);
    glVertex3f(-1,  1,  1);

    glNormal3f( 0,  0, -1);
    glVertex3f(-1, -1, -1);
    glVertex3f(-1,  1, -1);
    glVertex3f( 1,  1, -1);
    glVertex3f( 1, -1, -1);
    
    glColor3f(0.4, 1.0, 0.4);
    glNormal3f( 1,  0,  0);
    glVertex3f( 1, -1, -1);
    glVertex3f( 1,  1, -1);
    glVertex3f( 1,  1,  1);
    glVertex3f( 1, -1,  1);
    
    glNormal3f(-1,  0,  0);
    glVertex3f(-1, -1, -1);
    glVertex3f(-1,  1, -1);
    glVertex3f(-1,  1,  1);
    glVertex3f(-1, -1,  1);
    
    glColor3f(1.0, 0.4, 0.4);
    glNormal3f( 0,  1,  0);
    glVertex3f(-1,  1, -1);
    glVertex3f(-1,  1,  1);
    glVertex3f( 1,  1,  1);
    glVertex3f( 1,  1, -1);
    
    glNormal3f( 0, -1,  0);
    glVertex3f(-1, -1, -1);
    glVertex3f(-1, -1,  1);
    glVertex3f( 1, -1,  1);
    glVertex3f( 1, -1, -1);
    glEnd();

    if toggle: return
    
    # copy it into a texture
    glBindTexture(GL_TEXTURE_2D, texID)
    glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 0, 0, X, Y, 0)

    # clear the buffer
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

    # render the texture, sharpened

    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()

    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()

    shader.enable()
    glEnable(GL_TEXTURE_2D)
    glBindTexture(GL_TEXTURE_2D, texID)
    glBegin(GL_QUADS)
    glVertex3f(-1.00, -1, 0); glTexCoord2i(1, 0)
    glVertex3f(1.00, -1, 0);  glTexCoord2i(1, 1)
    glVertex3f(1.00, 1.000, 0);   glTexCoord2i(0, 1)
    glVertex3f(-1.00, 1.000, 0);  glTexCoord2i(0, 0)
    glEnd()    
    shader.disable()
    

def mainloop():
    global toggle
    glEnable(GL_DEPTH_TEST)
    glEnable(GL_LIGHTING)
    glEnable(GL_LIGHT0)
    glEnable(GL_COLOR_MATERIAL)

    glLightfv(GL_LIGHT0, GL_POSITION, (-3, 3, 4, 1));
    glLightfv(GL_LIGHT0, GL_DIFFUSE, (1, 1, 1, 1));

    glViewport(0, 0, X, Y)

    draw()
    
    for ev in pygame.event.get():
        if ev.type == QUIT: sys.exit()
        elif ev.type == KEYDOWN and ev.key == K_SPACE:
            toggle = not toggle
    pygame.display.flip()


if __name__ == '__main__':
    init()
    while 1:
        mainloop()
        time.sleep(0.001)
